from dataclasses import dataclass
from dataclasses_json import dataclass_json
import os
from typing import Tuple


CONFIG = None


def get_config():
    global CONFIG
    if CONFIG is None:
        CONFIG = Configs()
    return CONFIG


@dataclass_json
@dataclass
class Configs:
    mode: int = {'linux': 0,
                 'win': 1}['linux']
    debug_mode: bool = True
    feature_map_values_size: int = 100
    feature_map_layers_size: int = 65
    stats_used_in_feature_map: int = 12   # The size currently used in my tests taken from FeatureMapDataCreator
    feature_map_shape: Tuple = (feature_map_layers_size, feature_map_values_size, stats_used_in_feature_map)
    relevant_layers_names: Tuple = ('conv2d/kernel', 'dense/kernel', 'dense/bias')
    device: str = ['cuda', 'cpu'][0] if "PYCHARM_HOSTED" not in os.environ else 'cpu'
    seed: int = 42
    logger_path: str = ['/home//my_logs',
                        'C:\\Python Projects\\Research\\Performance_Predictor\\my_logs'][mode]
    force_data_write: bool = True          # should a function with save/load wrapper should force function activation
    joblib_compression_level: int = 4

